﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using static Edu.Library.Esy;
using Edu.Library.Collections;
using Edu.Library.Logo;
using Edu.Library.Helpers;
using Edu.Library.Mathematics;

namespace Edu.Library
{
    public static class Esy
    {
        public static IEduInOut InOut { get; set; }
        

        public static void Reset()
        {
            if (InOut != null) InOut.Clear();
            ResetTurtle();
        }

        public static void ClearTextArea()
        {
            InOut.Clear();  
        }

        public static void Write(params object[] values)
        {
            var concat = EsyString.Concat(values);
            InOut.Write(concat);
        }

        public static void MessageBox(params object[] values)
        {
            var concat = EsyString.Concat(values);
            InOut.MessageBox(concat);
        }

        public static bool ConfirmBox(params object[] values)
        {
            var concat = EsyString.Concat(values);
            var confirm = InOut.ConfirmBox(concat);
            return confirm;
        }

        public static string ReadString(params object[] values)
        {
            var concat = EsyString.Concat(values);
            return InOut.ReadText(concat);
        }

        public static int ReadInteger(params object[] values)
        {
            var concat = EsyString.Concat(values);
            return InOut.ReadInteger(concat);
        }

        public static bool ReadBoolean(params object[] values)
        {
            var concat = EsyString.Concat(values);
            return InOut.ReadBoolean(concat);
        }

        #region Turtle

        private static Logo.Turtle _turtle = new Logo.Turtle();

        public static void HT()
        {
            _turtle.HT();
        }

        public static void ST()
        {
            _turtle.ST();
        }

        public static void ResetTurtle()
        {
            _turtle = new Logo.Turtle();
            InOut.ClearScreen();
        }

            
        public static void CS()
        {
            _turtle.CS();
            InOut.ClearScreen();
        }

        public static void ClearScreen()
        {
            CS();
        }


        public static void Draw()
        {
            _turtle.Draw();
        }


        public static void PU()
        {
            _turtle.PU();
        }

        public static void PenUp()
        {
            PU();
        }

        public static void PD()
        {
            _turtle.PD();
        }

        public static void PenDown()
        {
            PD();
        }

        public static void FD(double pixels)
        {
            var line = _turtle.FD(pixels);
            InOut.Draw(line);
        }

        public static void Forward(double pixels)
        {
            FD(pixels);
        }

        public static void BK(double pixels)
        {
            var line = _turtle.BK(pixels);
            InOut.Draw(line);
        }

        public static void Backward(double pixels)
        {
            BK(pixels);
        }

        public static void BG(Color color)
        {
            _turtle.BG(color);
            InOut.Draw(_turtle.Lines, color);
        }

        public static void Background(Color color)
        {
            BG(color);
        }

        public static void PC(Color color)
        {
            _turtle.PC(color);
        }

        public static void PenColor(Color color)
        {
            PC(color);
        }

        public static void SetX(double x)
        {
            _turtle.SetX(x);
        }

        public static void SetY(double y)
        {
            _turtle.SetY(y);
        }

        public static void SetXY(double x, double y)
        {
            _turtle.SetXY(x, y);
        }

        public static void RT(double alpha = 90)
        {
            _turtle.RT(alpha);
        }

        public static void Right(double alpha = 90)
        {
            RT(alpha);
        }

        public static void LT(double alpha = 90)
        {
            _turtle.LT(alpha);
        }

        public static void Left(double alpha = 90)
        {
            LT(alpha);
        }

        public static void RTS()
        {
            _turtle.RT(22.5);
        }

        public static void LTS()
        {
            _turtle.LT(22.5);
        }

        public static void Towards(double x, double y)
        {
            _turtle.Towards(x, y);
        }

        public static void Home(bool resetDirection = true)
        {
            _turtle.Home(resetDirection);
        }

        public static double XCor
        {
            get { return _turtle.XCor; }
        }

        public static double YCor
        {
            get { return _turtle.YCor; }
        }

        public static double AlphaCor
        {
            get { return _turtle.AlphaCor; }
        }

        public static void DrawTurtle(Color color1, Color color2)
        {
            if (_turtle.Hidden) return;
            var lines = _turtle.GetTurtleLines(20, color1, color2);
            InOut.Draw(lines, null, false);
        }

        #endregion

        #region Turtle Graphical Functions

        public static void Rotate(double alpha, bool right = true)
        {
            if (right)
            {
                RT(alpha);
                return;
            }
            LT(alpha);
        }

        public static void FDBK(double pixels)
        {
            Esy.FD(pixels);
            Esy.BK(pixels);
        }

        public static void DrawRectangle(int edge1, int edge2, bool right = true)
        {
            FD(edge1);
            Rotate(90, right);
            FD(edge2);
            Rotate(90, right);
            FD(edge1);
            Rotate(90, right);
            FD(edge2);
            Rotate(90, right);
        }

        public static void FillRectangle(int edge1, int edge2)
        {
            for (int x = 0; x < edge2; x++)
            {
                FDBK(edge1);
                RT();
                FD(1);
                LT();
            }
            LT();
            FD(edge2);
            RT();
        }

        public static void DrawPolygon(int count, int edge, bool right = true)
        {
            var angle = (double)360 / count;

            for(int i = 0; i<count; i++)
            {
                FD(edge);
                Rotate(angle, right);
            }
        }

        public static void DrawCircle(int radius, bool right = true)
        {
            var edge = 1;
            var halfAngleRad = Math.Asin(0.5 * edge / radius);
            var count = (int)(Math.PI / halfAngleRad);
            DrawPolygon(count, edge, right);
        }

        public static void DrawTriangle(int edge, bool right = true)
        {
            Rotate(30, right);
            DrawPolygon(3, edge, right);
            Rotate(-30, right);
        }

        public static void DrawHalfRectangle(int edge1, int edge2, bool right = true)
        {
            FDBK(edge1);
            Rotate(90, right);
            FD(edge2);
            Rotate(-90, right);
            var alpha = Math.Atan((double)edge1 / edge2);
            var alphaDeg = 90 - EsyMath.RadToDeg(alpha);
            Rotate(-alphaDeg, right);
            var edge3 = Math.Sqrt(edge1 * edge1 + edge2 * edge2);
            FDBK(edge3);
            Rotate(alphaDeg, right);
            Rotate(90, right);
            BK(edge2);
            Rotate(-90, right);
        }

        public static void FillHalfRectangle(int edge1, int edge2, bool right = true)
        {
            var tan = (double)edge1 / edge2;
            for (int x = 0; x <= edge2; x++)
            {
                var l = edge2 - x;
                FDBK(tan * l);
                Rotate(90, right);
                FD(1);
                Rotate(-90, right);
            }
            Rotate(-90, right);
            FD(edge2);
            Rotate(90, right);
        }

        public static void FillTriangle(int edge, bool right = true)
        {
            var tan = Math.Tan(Math.PI / 3);
            for (int x = 0; x < edge / 2; x++)
            {
                var h =  (x + 1)  * tan;
                FDBK(h);
                RT();
                FD(1);
                LT();
            }
            for (int x = edge / 2; x > 0; x--)
            {
                var h = x * tan;
                FDBK(h);
                RT();
                FD(1);
                LT();
            }
            LT();
            FD(edge);
            RT();
        }

        public static void DrawStar(int count, int radius)
        {
            var angle = (double)360 / count;

            for (int i = 0; i < count; i++)
            {
                FDBK(radius);
                RT(angle);
            }
        }

        public static void FillCircle(int radius)
        {
            var edge = 1.0;
            var halfAngleRad = Math.Asin(0.5 * edge / radius);
            var count = (int)(Math.PI/ halfAngleRad);
            DrawStar(count, radius);
        }

        #endregion

        #region Music

        const string WHOLE = "1";
        const string HALF = "1/2";
        const string HALFDOT = "1/2.";
        const string FOURTH = "1/4";
        const string FOURTHDOT = "1/4.";
        const string EIGHT = "1/8";
        const string EIGTHDOT = "1/8.";
        const string SIXTEENHT = "1/16";
        const string SIXTEENHTDOT = "1/16.";

        private static int Tempo = 80;

        public static void SetTempo(int bpm)
        {
            Tempo = bpm;
        }

        /// <summary>
        /// Tempo = 60 BPM => 1 patrime = 1s
        /// </summary>
        /// <param name="noteType"></param>
        /// <returns></returns>
        public static double GetDuration(string noteType)
        {
            var fourthDuration = (double)60 / Tempo;
            var halfDuration = 2 * fourthDuration;
            var eightDuration = fourthDuration / 2;
            var sixteenthDuration = eightDuration / 2;

            double seconds = 0;

            switch (noteType)
            {
                case WHOLE:
                    seconds = fourthDuration * 4;
                    break;
                case HALF:
                    seconds = halfDuration;
                    break;
                case HALFDOT:
                    seconds = 1.5 * halfDuration;
                    break;
                case FOURTH:
                    seconds = fourthDuration;
                    break;
                case FOURTHDOT:
                    seconds = fourthDuration * 1.5;
                    break;
                case EIGHT:
                    seconds = eightDuration;
                    break;
                case EIGTHDOT:
                    seconds = 1.5 * eightDuration;
                    break;
                case SIXTEENHT:
                    seconds = sixteenthDuration;
                    break;
                case SIXTEENHTDOT:
                    seconds = 1.5 * sixteenthDuration;
                    break;
            }

            return seconds;
        }

        public static void Pause(int ms)
        {
            System.Threading.Thread.Sleep(ms);
        }

        public static void Pause(string noteType = FOURTH)
        {
            var seconds = GetDuration(noteType);
            var ms = (int)(1000 * seconds);
            Pause(ms);
        }

        public static void Beep(int frequency, int ms)
        {
            Console.Beep(frequency, ms);
        }
        
        public static void Beep(int frequency, double seconds, int octave)
        {
            var octaveFactor = (int)Math.Pow(2, (octave - 1));
            frequency = octaveFactor * frequency;
            var ms = (int)(1000 * seconds);
            Beep(frequency, ms);
        }

        public static void Beep(int requency, string noteType, int octave)
        {
            var seconds = GetDuration(noteType);
            Beep(requency, seconds, octave);
        }

        public static void DO(string noteType = FOURTH)
        {
            Beep(262, noteType, 1);
        }

        public static void DOH(string noteType = FOURTH)
        {
            Beep(277, noteType, 1);
        }

        public static void RE(string noteType = FOURTH)
        {
            Beep(294, noteType, 1);
        }

        public static void REH(string noteType = FOURTH)
        {
            Beep(311, noteType, 1);
        }

        public static void MI(string noteType = FOURTH)
        {
            Beep(330, noteType, 1);
        }

        public static void FA(string noteType = FOURTH)
        {
            Beep(349, noteType, 1);
        }

        public static void FAH(string noteType = FOURTH)
        {
            Beep(370, noteType, 1);
        }
        public static void SOL(string noteType = FOURTH)
        {
            Beep(392, noteType, 1);
        }

        public static void SOLH(string noteType = FOURTH)
        {
            Beep(415, noteType, 1);
        }

        public static void LA(string noteType = FOURTH)
        {
            Beep(440, noteType, 1);
        }

        public static void LAH(string noteType = FOURTH)
        {
            Beep(466, noteType, 1);
        }
        public static void SI(string noteType = FOURTH)
        {
            Beep(494, noteType, 1);
        }

        public static void DO2(string noteType = FOURTH)
        {
            Beep(262, noteType, 2);
        }

        public static void DOH2(string noteType = FOURTH)
        {
            Beep(277, noteType, 2);
        }

        public static void RE2(string noteType = FOURTH)
        {
            Beep(294, noteType, 2);
        }

        public static void REH2(string noteType = FOURTH)
        {
            Beep(311, noteType, 2);
        }

        public static void MI2(string noteType = FOURTH)
        {
            Beep(330, noteType, 2);
        }

        public static void FA2(string noteType = FOURTH)
        {
            Beep(349, noteType, 2);
        }

        public static void FAH2(string noteType = FOURTH)
        {
            Beep(370, noteType, 2);
        }
        public static void SOL2(string noteType = FOURTH)
        {
            Beep(392, noteType, 2);
        }

        public static void SOLH2(string noteType = FOURTH)
        {
            Beep(415, noteType, 2);
        }

        public static void LA2(string noteType = FOURTH)
        {
            Beep(440, noteType, 2);
        }

        public static void LAH2(string noteType = FOURTH)
        {
            Beep(466, noteType, 2);
        }
        public static void SI2(string noteType = FOURTH)
        {
            Beep(494, noteType, 2);
        }

        public static void DO3(string noteType = FOURTH)
        {
            Beep(262, noteType, 3);
        }

        #endregion
    }
}
